      SUBROUTINE DCFFTI(N,WSAVE)    
C***BEGIN PROLOGUE  DCFFTI
C***DATE WRITTEN   790601   (YYMMDD)    
C***REVISION DATE  860115   (YYMMDD)    
C***CATEGORY NO.  J1A2   
C***KEYWORDS  FOURIER TRANSFORM    
C***AUTHOR  SWARZTRAUBER, P. N., (NCAR) 
C***PURPOSE  Initialize for DCFFTF and DCFFTB. 
C***DESCRIPTION
C           From the book, "Numerical Methods and Software" by
C                D. Kahaner, C. Moler, S. Nash
C                Prentice Hall, 1988
C    
C  Subroutine DCFFTI initializes the array WSAVE which is used in 
C  both DCFFTF and DCFFTB.  The prime factorization of N together with  
C  a tabulation of the trigonometric functions are computed and  
C  stored in WSAVE. 
C    
C  Input Parameter  
C    
C  N       the length of the sequence to be transformed
C    
C  Output Parameter 
C    
C  WSAVE   a work array which must be dimensioned at least 4*N+15.    
C          The same work array can be used for both DCFFTF and DCFFTB   
C          as long as N remains unchanged.  Different WSAVE arrays    
C          are required for different values of N.  The contents of   
C          WSAVE must not be changed between calls of DCFFTF or DCFFTB. 
C***REFERENCES  (NONE)   
C***ROUTINES CALLED  DCFTI1   
C***END PROLOGUE  DCFFTI  
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION       WSAVE(*)
C***FIRST EXECUTABLE STATEMENT  DCFFTI   
      IF (N .EQ. 1) RETURN    
      IW1 = N+N+1   
      IW2 = IW1+N+N 
      CALL DCFTI1 (N,WSAVE(IW1),WSAVE(IW2))  
      RETURN   
      END 
